//
//  MSWViewController.h
//  Midi to Switch for iOS
//
//  Created by Tim Gerber on 13.01.13.
//  Copyright (c) 2013 Tim Gerber. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PGMidi.h"

@interface MSWViewController : UIViewController

@property (weak, nonatomic) IBOutlet UISwitch *invertSwitch; //
@property (weak, nonatomic) IBOutlet UISwitch *toggleSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *pulseSwitch;//
@property (weak, nonatomic) IBOutlet UISwitch *swpSwitch;//
@property (weak, nonatomic) IBOutlet UISwitch *directSwitch;//
@property (weak, nonatomic) IBOutlet UIStepper *idStepper;//
@property (weak, nonatomic) IBOutlet UILabel *idLabel;//
@property (weak, nonatomic) IBOutlet UIStepper *channelStepper;//
@property (weak, nonatomic) IBOutlet UILabel *channelLabel;//
@property (weak, nonatomic) IBOutlet UIStepper *befehlStepper;//
@property (weak, nonatomic) IBOutlet UILabel *befehlLabel;//
@property (weak, nonatomic) IBOutlet UIStepper *wertStepper;
@property (weak, nonatomic) IBOutlet UILabel *wertLabel;
@property (weak, nonatomic) IBOutlet UIButton *sendButton;
@property (weak, nonatomic) IBOutlet UISlider *zeitSlider;
@property (weak, nonatomic) IBOutlet UILabel *zeitLabel;

- (IBAction)send:(id)sender;
- (IBAction)test:(id)sender;
- (IBAction)inverse:(id)sender;
- (IBAction)toggle:(id)sender;
- (IBAction)pulse:(id)sender;
- (IBAction)swp:(id)sender;
- (IBAction)idChange:(id)sender;
- (IBAction)channelChange:(id)sender;
- (IBAction)befehlChange:(id)sender;
- (IBAction)wertChange:(id)sender;
- (IBAction)zeitChange:(id)sender;

@property (nonatomic) PGMidi *midi;

@end
